'use strict';

angular.module('genisis').controller('navigationCtrl', ['$scope', '$location',
  '$rootScope', 'user', '$route', '$window',
  function ($scope, $location, $rootScope, $user, $route, $window) {

    $scope.tabs = [{
        title: 'Dashboard',
        icon: 'home',
        path: '/dashboard',
        aria: 'dashboard',
        active: false,
        roles: [], //['researcher', 'manager', 'Administrator'],
        tabindex: 1
      }, {
        title: 'My Requests',
        icon: 'file',
        path: '/requests',
        aria: 'requests',
        active: false,
        roles: ['requester'],
        tabindex: 0
      }, {
        title: 'Requests',
        icon: 'file',
        path: '/requests',
        aria: 'requests',
        active: false,
        roles: ['Genisis2 Manager', 'VINCI Manager',
          'Administrator'
        ],
        tabindex: 0
      },
      {
        title: 'System Administration',
        icon: 'file',
        path: '/systemAdministration',
        aria: 'systemAdministration',
        active: false,
        roles: ['Administrator'],
        tabindex: 1
      }, {
        title: 'Study Approvals',
        icon: 'check',
        path: '/studyApprovals',
        aria: 'studyApprovals',
        active: false,
        roles: [],
        tabindex: 3
      }
    ];

    /**
     * Return an array of tabs the user has access to based on their role
     * @return Object[] tab data
     **/
    $scope.userTabs = function () {
      var tabs = [];

      for (var i = 0; i < $scope.tabs.length; i++) {
        if ($scope.tabs[i].roles.indexOf($user.permissions()) !== -1) {
          tabs.push($scope.tabs[i]);
        }
      }

      return tabs;
    };

    /**
     * Route to the selected tab
     * @param object tab data
     **/
    $scope.changeTab = function (tab) {
      if (tab.path === $location.path()) {
        $window.location.reload();
      } else {
        $location.path(tab.path);
      }
    };

    //update the active tab when the route changes
    $scope.$on('$routeChangeSuccess', function () {

      //clear out our messages
      $rootScope.errors = [];
      $rootScope.warnings = [];
      $rootScope.messages = [];

      //set the active tab
      for (var i = 0; i < $scope.tabs.length; i++) {
        $scope.tabs[i].active = ($scope.tabs[i].path ===
          $location.path());
      }
    });
  }
]);